
/**
 * PG加载页中右下角的镭射标签SVG动画
 */
const lG = [
    ['0', "#d888f3", "#d888f3;#fee8a1;#a0f5b2;#30f4e1;#42b1ff;#78fbf0;#a3bdfa;#d888f3;"],
    ["0.5", "#8aadff", "#8aadff;#78fbf0;#42b1ff;#8aadff;#a0f5b2;fee8a1;#d888f3;#8aadff;"],
    ['1', "#30f4e1", "#30f4e1;#d888f3;#42b1ff;#8aadff;#a0f5b2;#78fbf0;#78fbf0;#30f4e1;"]
];
const lR = {
    'PG-Color-Top': "PG-Color-Top",
    'PG-Color-Bottom': "PG-Color-Bottom",
    'PG1': "PG1",
    'PG2': "PG2",
    'PG3': "PG3",
    'PG4': "PG4",
    'PG5': "PG5"
}
const lb = {
    'yellow': ["G-Yelow", 5],
    'green': ["G-Green", 10],
    'darkRed': ["G-Dark-Red", 5],
    'orange': ["P-Orange", 10],
    'purple': ["P-Purple", 5]
}

function setAnimData(data) {
    var TJ = data["element"],
        Tw = data["duration"],
        TO = data["delay"];
    divSetAttr(createSVG(TJ, "animate"), "attributeName", "opacity", "dur", Tw + 's', "values", "0; 0; 1;", "keyTimes", "0; " + (TO || 0) + "; 1", "end", "indefinite");
}

function createElement(parentNode, ele) {
    let item = document.createElement(ele)
    parentNode.appendChild(item)
    return item;
}

function createSVG(divNode, ele) {
    var node = document.createElementNS("http://www.w3.org/2000/svg", ele)
    divNode.appendChild(node)
    return node;
}

function divSetAttr() {
    for (var Tg = arguments, TJ = Tg[0], Tw = 1; Tw < Tg.length; Tw += 2) TJ.setAttribute(Tg[Tw], Tg[Tw + 1]);
    return TJ;
}

function divSetStyle() {
    for (var Tg = arguments, TJ = Tg[0], Tw = 1; Tw < Tg["length"]; Tw += 2) TJ["style"][Tg[Tw]] = Tg[Tw + 1];
    return TJ;
}

function setHTML(node, htmlContent) {
    return node["innerHTML"] += htmlContent, node;
}
function createPGTag(isPortrait) {
    if (isPortrait == null) {
        isPortrait = true
    }

    let pixRatio = window.devicePixelRatio || 1

    var svgLogoDiv = document.createElement("div");
    let sty = isPortrait ? "column" : "row"
    divSetAttr(svgLogoDiv, 'id', "svg-logo")
    divSetStyle(svgLogoDiv, "display", "flex", "flex-direction", sty, "backface-visibility", "hidden", "transform", "translateZ(0)");

    let sv1 = createSVG(svgLogoDiv, "svg")
    let sv2 = createSVG(sv1, "svg")

    divSetAttr(sv1, 'id', "gradient-color", "xmlns", "http://www.w3.org/2000/svg")
    divSetStyle(sv1, "position", "absolute", "z-index", "-99", "opacity", '0')
    divSetAttr(sv2, 'id', "logo-gradient")
    divSetStyle(sv2, "position", "absolute", "z-index", '1', "clip-path", "url(#logo-clip-path)", "width", "200px", "height", "100px")

    var TV = createSVG(createElement(sv1, "defs"), "linearGradient")
    divSetAttr(TV, 'id', "color-a", "gradientUnits", "objectBoundingBox", 'x1', '0', 'y1', '0', 'x2', '1', 'y2', '1')
    divSetAttr(createSVG(sv2, "clipPath"), 'id', "logo-clip-path")
    divSetAttr(createSVG(sv2, "rect"), "fill", "url(#color-a)", "width", "200px", "height", "100px")

    var TZ = createSVG(sv2, 'g')
    var Tx = createSVG(TZ, "rect")
    divSetAttr(Tx, "fill", "white", "width", "10px", "height", "70px")
    divSetStyle(Tx, "transform", "rotate(30deg)")
    divSetAttr(TZ, "transform", "translate(-80, -10)")
    divSetAttr(createElement(TZ, "animateTransform"), 'id', "shine-animate", "attributeName", "transform", "type", "translate", "from", "-80 -10", 'to', "160 -10", "dur", '1s', "begin", "2s;shine-animate.end+2s", "end", "indefinite")
    lG.forEach(function (Tq) {
        var Tz = createSVG(TV, "stop");
        divSetAttr(Tz, "offset", Tq[0], "stop-color", Tq[1])
        divSetAttr(createElement(Tz, "animate"), 'id', "color-" + Tq[1], "attributeName", "stop-color", "values", Tq[2], "dur", '6s', "repeatCount", "indefinite")
    });

    var svg3 = createElement(svgLogoDiv, "div");
    divSetAttr(svg3, 'id', "svg-logo-container")
    divSetStyle(svg3, "height", "31px", "width", isPortrait ? "62px" : "67px")
    divSetStyle(svg3)
    setHTML(svg3, "<svg id=\"pg-svg-logo\" width=\"62\" height=\"28\" viewBox=\"0 0 62 28\" xmlns=\"http://www.w3.org/2000/svg\" overflow=\"visible\">\n<g id=\"PG-Logo\">\n<g id=\"PG-Color-Top\">\n<path id=\"G-Yelow\" fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M41.75 0H39.25V2.49997H41.75V0Z\" fill=\"#FFB919\"/>\n<path id=\"G-Green\" fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M61.5 11.2499H59V13.7498H61.5V11.2499Z\" fill=\"#14E691\"/>\n<path id=\"G-Dark-Red\" fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M36 5.74994H33.5V8.24991H36V5.74994Z\" fill=\"#E61973\"/>\n<path id=\"P-Orange\" fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M28 2.74997H25.5V5.24994H28V2.74997Z\" fill=\"#FF6E00\"/>\n<path id=\"P-Purple\" fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M2.5 2.74997H0V5.24994H2.5V2.74997Z\" fill=\"#6414E6\"/>\n</g>\n<g id=\"PG-Color-Bottom\">\n<path id=\"Fill-18\" fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M2.75 27.8544H5.20367V25.4042H2.75V27.8544Z\" fill=\"#19BEE6\"/>\n<path id=\"Fill-19\" fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M16.9104 22.2H19.3649V19.7498H16.9104V22.2Z\" fill=\"#E619DC\"/>\n<path id=\"Fill-24\" fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M36.2829 25.0272H38.7374V22.577H36.2829V25.0272Z\" fill=\"#1987E6\"/>\n<path id=\"Fill-25\" fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M53.2754 27.8544H55.7304V25.4042H53.2754V27.8544Z\" fill=\"#FF4B00\"/>\n<path id=\"Fill-27\" fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M58.9402 22.2H61.3948V19.7502H58.9402V22.2Z\" fill=\"#FF1928\"/>\n</g>\n<g id=\"PG5\">\n<path id=\"Fill-20\" fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M16.993 2.45026H19.448V0H16.993V2.45026ZM8.4965 5.27791H10.9511V2.82764H8.4965V5.27791ZM19.8252 8.10465H22.2797V5.65439H19.8252V8.10465ZM25.4899 10.9323H27.9441V8.48158H25.4899V10.9323ZM0 13.7586H2.45457V11.3097H0V13.7586ZM25.4899 16.5862H27.9441V14.136H25.4899V16.5862ZM11.3287 22.2406H13.7832V19.7903H11.3287V22.2406ZM2.83217 25.0678H5.28674V22.6175H2.83217V25.0678ZM0 10.9323H2.45457V8.48203H0V10.9323ZM22.6573 5.27746H25.1119V2.82719H22.6573V5.27746Z\" fill=\"white\"/>\n<path id=\"Fill-21\" fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M50.5263 2.45026H52.9809V0H50.5263V2.45026ZM53.3585 8.10465H55.8126V5.65439H53.3585V8.10465ZM39.1977 8.10465H41.6518V5.65439H39.1977V8.10465ZM53.3585 16.5862H55.8126V14.136H53.3585V16.5862ZM59.0228 19.4134H61.4774V16.9636H59.0228V19.4134ZM44.862 25.0683H47.3166V22.618H44.862V25.0683ZM50.5263 27.895H52.9809V25.4447H50.5263V27.895Z\" fill=\"white\"/>\n</g>\n<g id=\"PG4\">\n<path id=\"Fill-20_2\" fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M2.83217 2.45026H5.28583V0H2.83217V2.45026ZM14.1613 5.27791H16.6159V2.82764H14.1613V5.27791ZM2.83217 8.1051H5.28674V5.65484H2.83217V8.1051ZM22.6573 10.9323H25.1119V8.48158H22.6573V10.9323ZM2.83217 16.5867H5.28674V14.1364H2.83217V16.5867ZM14.1613 19.4134H16.6159V16.9636H14.1613V19.4134ZM0 22.2406H2.45457V19.7908H0V22.2406Z\" fill=\"white\"/>\n<path id=\"Fill-21_2\" fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M42.0294 5.27744H44.4839V2.82718H42.0294V5.27744ZM56.1902 13.7595H58.6448V11.3097H56.1902V13.7595ZM47.6937 13.7595H50.1483V11.3097H47.6937V13.7595ZM33.5329 16.5867H35.9879V14.1364H33.5329V16.5867ZM56.1902 22.2406H58.6448V19.7903H56.1902V22.2406Z\" fill=\"white\"/>\n</g>\n<g id=\"PG3\">\n<path id=\"Fill-20_3\" fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M8.4965 2.45026H10.9511V0H8.4965V2.45026ZM19.8252 5.27791H22.2797V2.82764H19.8252V5.27791ZM16.993 5.27791H19.448V2.82764H16.993V5.27791ZM5.66388 5.27791H8.1189V2.82764H5.66388V5.27791ZM22.6573 8.10465H25.1119V5.65439H22.6573V8.10465ZM2.83217 10.9323H5.28674V8.48158H2.83217V10.9323ZM22.6573 13.759H25.1119V11.3088H22.6573V13.759ZM22.6573 16.5862H25.1119V14.136H22.6573V16.5862ZM0 16.5858H2.45457V14.1364H0V16.5858ZM22.6573 19.4134H25.1119V16.9636H22.6573V19.4134ZM5.66388 19.4134H8.1189V16.9636H5.66388V19.4134ZM14.1613 22.2406H16.6159V19.7903H14.1613V22.2406ZM5.66388 22.2406H8.1189V19.7903H5.66388V22.2406Z\" fill=\"white\"/>\n<path id=\"Fill-21_3\" fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M42.0298 2.45026H44.4844V0H42.0298V2.45026ZM44.862 5.27746H47.3166V2.82719H44.862V5.27746ZM53.3585 5.27791H55.8126V2.82764H53.3585V5.27791ZM36.3655 10.9323H38.8201V8.48158H36.3655V10.9323ZM36.3655 13.759H38.8201V11.3088H36.3655V13.759ZM56.1902 19.4143H58.6448V16.9636H56.1902V19.4143ZM39.1977 22.2411H41.6518V19.7908H39.1977V22.2411ZM53.3585 25.0678H55.8126V22.6175H53.3585V25.0678ZM42.0298 27.895H44.4844V25.4447H42.0298V27.895Z\" fill=\"white\"/>\n</g>\n<g id=\"PG2\">\n<path id=\"Fill-20_4\" fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M19.8261 2.45026H22.2797V0H19.8261V2.45026ZM11.3291 2.45026H13.7828V0H11.3291V2.45026ZM2.83217 5.27791H5.28674V2.82764H2.83217V5.27791ZM25.4899 8.10465H27.9441V5.65439H25.4899V8.10465ZM0 8.1042H2.45457V5.65484H0V8.1042ZM2.83217 13.7595H5.28674V11.3097H2.83217V13.7595ZM19.8252 16.5862H22.2797V14.136H19.8252V16.5862ZM19.8252 19.4134H22.2797V16.9636H19.8252V19.4134ZM16.993 19.4134H19.448V16.9636H16.993V19.4134ZM2.83217 19.4134H5.28674V16.9636H2.83217V19.4134ZM8.4965 22.2406H10.9511V19.7903H8.4965V22.2406ZM2.83217 22.2406H5.28674V19.7903H2.83217V22.2406ZM0 27.895H2.45457V25.4447H0V27.895Z\" fill=\"white\"/>\n<path id=\"Fill-21_4\" fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M47.6941 2.45026H50.1478V0H47.6941V2.45026ZM47.6937 5.27746H50.1483V2.82719H47.6937V5.27746ZM56.1902 5.27791H58.6448V2.82764H56.1902V5.27791ZM39.1977 5.27791H41.6518V2.82764H39.1977V5.27791ZM56.1902 8.10465H58.6448V5.65439H56.1902V8.10465ZM36.3655 8.1051H38.8201V5.65484H36.3655V8.1051ZM53.3585 13.7595H55.8126V11.3097H53.3585V13.7595ZM33.5329 13.7595H35.9879V11.3097H33.5329V13.7595ZM50.5259 16.5862H52.9804V14.136H50.5259V16.5862ZM47.6937 16.5862H50.1483V14.136H47.6937V16.5862ZM59.0228 16.5858H61.4774V14.1364H59.0228V16.5858ZM36.3655 19.4134H38.8201V16.9636H36.3655V19.4134ZM33.5329 19.4143H35.9879V16.9636H33.5329V19.4143ZM53.3585 22.2411H55.8126V19.7908H53.3585V22.2411ZM36.3655 22.2411H38.8201V19.7908H36.3655V22.2411ZM56.1902 25.0678H58.6448V22.6175H56.1902V25.0678ZM47.6937 25.0683H50.1483V22.618H47.6937V25.0683ZM39.1977 25.0683H41.6518V22.618H39.1977V25.0683ZM47.6941 27.895H50.1478V25.4447H47.6941V27.895ZM44.8615 27.895H47.3166V25.4447H44.8615V27.895Z\" fill=\"white\"/>\n</g>\n<g id=\"PG1\">\n<path id=\"Fill-20_5\" fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M19.8261 2.45026H22.2797V0H19.8261V2.45026ZM14.1613 2.45026H16.6149V0H14.1613V2.45026ZM5.66478 2.45026H8.118V0H5.66478V2.45026ZM11.3287 5.27791H13.7832V2.82764H11.3287V5.27791ZM22.6573 8.10465H25.1119V5.65439H22.6573V8.10465ZM0 8.1042H2.45457V5.65484H0V8.1042ZM25.4899 13.759H27.9441V11.3088H25.4899V13.759ZM11.3287 19.4134H13.7832V16.9636H11.3287V19.4134ZM8.4965 19.4134H10.9511V16.9636H8.4965V19.4134ZM0 19.4134H2.45457V16.9636H0V19.4134ZM14.1613 22.2406H16.6159V19.7903H14.1613V22.2406ZM0 25.0669H2.45457V22.618H0V25.0669Z\" fill=\"white\"/>\n<path id=\"Fill-21_5\" fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M44.8615 2.45026H47.3166V0H44.8615V2.45026ZM50.5259 5.27746H52.9804V2.82719H50.5259V5.27746ZM36.3655 5.27791H38.8201V2.82764H36.3655V5.27791ZM33.5329 10.9323H35.9879V8.48158H33.5329V10.9323ZM50.5259 13.7595H52.9804V11.3097H50.5259V13.7595ZM36.3655 16.5862H38.8201V14.136H36.3655V16.5862ZM56.1902 16.5867H58.6448V14.1364H56.1902V16.5867ZM33.5329 22.2406H35.9879V19.7903H33.5329V22.2406ZM50.5259 25.0683H52.9804V22.618H50.5259V25.0683ZM42.0294 25.0683H44.4839V22.618H42.0294V25.0683ZM39.1981 27.895H41.6513V25.4447H39.1981V27.895Z\" fill=\"white\"/>\n</g>\n</g>\n</svg>")
    setHTML(svgLogoDiv, isPortrait ? "<svg id=\"pg-svg-text\" width=\"67\" height=\"5\" viewBox=\"0 0 67 5\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\">\n<g id=\"PG-Title\">\n<path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M0 0.00732803V4.5H1.12546V2.80277H2.82616V2.25366H3.4014V0.581392H2.82616V0.00732803H0ZM1.12546 1.70456H2.25093V1.1305H1.12546V1.70456Z\" fill=\"white\"/>\n<path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M4.50187 0.00732803V0.581392H3.92664V3.9509H4.50187V4.5H6.7528V3.9509H7.32804V0.581392H6.7528V0.00732803H4.50187ZM5.07711 1.1305H6.20257V3.37683H5.07711V1.1305Z\" fill=\"white\"/>\n<path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M8.45349 0.00732803V0.581392H7.90326V3.9509H8.45349V4.5H10.7294V3.9509H11.2796V2.82773H10.1542V3.37683H9.02872V1.1305H10.1542V1.70456H11.2796V0.581392H10.7294V0.00732803H8.45349Z\" fill=\"white\"/>\n<path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M14.1058 0.00732803V1.70456H12.9804V0.00732803H11.8549V4.5H12.9804V2.82773H14.1058V4.5H15.2313V2.82773H14.6811V1.70456H15.2313V0.00732803H14.1058Z\" fill=\"white\"/>\n<path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M15.8065 0.00732803V4.5H19.1829V3.37683H16.932V2.82773H18.6077V1.70456H16.932V1.1305H19.1829V0.00732803H15.8065Z\" fill=\"white\"/>\n<path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M19.7582 0.00732803V1.1305H20.8836V4.5H22.0091V1.1305H23.1346V0.00732803H19.7582Z\" fill=\"white\"/>\n<path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M25.3855 0.00732803V0.581392H24.8353V3.9509H25.3855V4.5H27.6364V3.9509H28.2117V1.70456H26.511V2.82773H27.0862V3.37683H25.9607V1.1305H27.6364V0.00732803H25.3855Z\" fill=\"white\"/>\n<path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M29.3371 0.00732803V0.556432H28.7618V4.5H29.8873V3.37683H31.0128V4.5H32.1382V0.556432H31.563V0.00732803H29.3371ZM29.9123 2.25366H31.0378V1.1305H29.9123V2.25366Z\" fill=\"white\"/>\n<path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M36.1149 0.00732803V0.581392H35.5397V1.1305H34.9894V1.70456H34.4142V1.1305H33.864V0.581392H33.2887V0.00732803H32.7135L32.7385 4.5H33.864V2.82773H34.4142V3.37683H34.9894V2.82773H35.5397V4.5H36.6651V0.00732803H36.1149Z\" fill=\"white\"/>\n<path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M37.2403 0.00732803V4.5H40.6167V3.37683H38.3658V2.82773H40.0665V1.70456H38.3658V1.1305H40.6167V0.00732803H37.2403Z\" fill=\"white\"/>\n<path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M41.7422 0.00732803V0.581392H41.192V2.25366H41.7422V2.82773H43.4429V3.37683H41.192V4.5H44.0181V3.9509H44.5683V2.25366H44.0181V1.70456H42.3174V1.1305H44.5683V0.00732803H41.7422Z\" fill=\"white\"/>\n<path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M46.8193 0.00732803V0.581392H46.269V2.25366H46.8193V2.82773H48.52V3.37683H46.269V4.5H49.0952V3.9509H49.6454V2.25366H49.0952V1.70456H47.3945V1.1305H49.6454V0.00732803H46.8193Z\" fill=\"white\"/>\n<path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M50.7709 0.00732803V0.581392H50.1957V3.9509H50.7709V4.5H53.0218V3.9509H53.5971V0.581392H53.0218V0.00732803H50.7709ZM51.3462 3.37683H52.4716V1.1305H51.3462V3.37683Z\" fill=\"white\"/>\n<path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M54.1723 0.00732803V4.5H55.2978V2.82773H56.9985V1.70456H55.2978V1.1305H57.5487V0.00732803H54.1723Z\" fill=\"white\"/>\n<path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M58.124 0.00732803V1.1305H59.2494V4.5H60.3749V1.1305H61.5004V0.00732803H58.124Z\" fill=\"white\"/>\n<path d=\"M62.7488 1.92186V0.299511H62.2736V0H63.5241V0.299511H63.0239V1.92186H62.7488ZM63.7742 1.92186V0.0249608H64.0994L64.7246 1.24796L65.3249 0.0249608H65.65V1.92186H65.3499V0.623982L64.8997 1.54748H64.5746L64.0744 0.574064V1.89691H63.7742V1.92186Z\" fill=\"white\"/>\n</g>\n</svg>" : "<svg id=\"pg-svg-text\" width=\"48\" height=\"29\" viewBox=\"0 0 48 29\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\">\n<g id=\"PG-Title\">\n<path id=\"Fill\" d=\"M4.76178 0H0V7.64272H1.90821V4.77452H4.76178V3.81262H5.70714V0.961899H4.76178V0ZM3.81643 2.86821H1.90821V1.90631H3.81643V2.86821ZM7.61535 7.64272H11.4318V6.68082H12.3771V0.961899H11.4318V0H7.61535V0.961899H6.67V6.69831H7.61535V7.64272ZM8.56071 1.90631H10.4689V5.73641H8.56071V1.90631ZM14.2853 7.64272H18.1018V6.68082H19.0471V4.77452H17.1389V5.73641H15.2307V1.90631H17.1389V2.86821H19.0471V0.961899H18.1018V0H14.2853V0.961899H13.34V6.69831H14.2853V7.64272ZM21.9007 4.77452H23.8089V7.64272H25.7171V4.77452H24.7718V2.86821H25.7171V0H23.8089V2.86821H21.9007V0H19.9925V7.64272H21.9007V4.77452ZM32.3696 5.73641H28.5532V4.77452H31.4068V2.86821H28.5532V1.90631H32.3696V0H26.6625V7.64272H32.3696V5.73641ZM33.3325 0V1.90631H35.2407V7.64272H37.1489V1.90631H39.0396V0H33.3325ZM2.85357 14.9532H3.79892V15.9151H1.90821V12.0849H4.76178V10.1611H0.945354V11.123H0V16.8595H0.945354V17.8214H4.76178V16.8595H5.70714V13.0294H2.85357V14.9532ZM11.4318 10.1611H7.61535V11.123H6.67V17.8214H8.57821V15.8976H10.4864V17.8039H12.3946V11.123H11.4493L11.4318 10.1611ZM10.4689 13.9913H8.56071V12.0849H10.4689V13.9913ZM18.0843 12.0849H17.1389V13.0468H16.1936V12.0849H15.2307V11.123H14.2853V10.1611H13.34V17.8039H15.2307V14.9532H16.1936V15.9151H17.1389V14.9532H18.0843V17.8214H19.9925V10.1611H19.0471V11.123H18.1018L18.0843 12.0849ZM20.9553 17.8214H26.6625V15.8976H22.8461V14.9357H25.6996V13.0294H22.8461V12.0675H26.6625V10.1611H20.9553V17.8214ZM28.5707 11.123H27.6253V13.9913H28.5707V14.9532H31.4243V15.9151H27.6078V17.8214H32.3696V16.8595H33.315V13.9913H32.3696V13.0294H29.5161V12.0675H33.3325V10.1611H28.5707V11.123ZM0.945354 21.2842H0V24.1524H0.945354V25.1143H3.79892V26.0762H0V27.9825H4.76178V27.0206H5.70714V24.1524H4.76178V23.1905H1.90821V22.2286H5.72464V20.3223H0.945354V21.2842ZM11.4318 20.3398H7.61535V21.3017H6.67V27.0381H7.61535V28H11.4318V27.0381H12.3771V21.3017H11.4318V20.3398ZM10.4689 26.0762H8.56071V22.2461H10.4689V26.0762ZM13.3225 27.9825H15.2307V25.1143H18.0843V23.208H15.2307V22.2461H19.0471V20.3398H13.3225V27.9825ZM19.9925 22.2461H21.9007V27.9825H23.8089V22.2461H25.7171V20.3398H20.01L19.9925 22.2461Z\" fill=\"white\"/>\n<path id=\"Vector\" d=\"M41.8057 3.25297V0.489694H40.9828V0H43.1186V0.489694H42.3133V3.25297H41.8057ZM43.5563 3.25297V0H44.099L45.1669 2.0812L46.1823 0H46.725V3.25297H46.2173V1.03186L45.447 2.62336H44.8868L44.0465 0.979388V3.25297H43.5563Z\" fill=\"white\"/>\n</g>\n</svg>")
    return svgLogoDiv
}

let pgTagIntvalTimerID = null
let TimerID = null
function startPGTagAnim(isPortrait) {
    if (isPortrait == null) {
        isPortrait = true
    }
    let pcb = document.getElementById(lR["PG-Color-Bottom"])
    setAnimData({
        'element': document.getElementById(lR["PG-Color-Top"]),
        'duration': 0.5
    })
    setAnimData({
        'element': pcb,
        'duration': 0.5
    });

    for (let i = 1; i <= 5; i++) {
        setAnimData({
            'element': document.getElementById(lR['PG' + i]),
            'duration': 0.5,
            'delay': 1 === i ? 0.3 : 0.1 * i + 0.3
        });
    }

    let pgTitle = document.getElementById("PG-Title")
    let pgText = document.getElementById("pg-svg-text")
    let animTransSVG = createSVG(pgTitle, "animateTransform")
    let animSVG = createSVG(pgText, "animate")
    let TC, TW
    divSetAttr(animTransSVG, "attributeName", "transform", "type", "translate", "dur", "1.5s", "values", '0 ' + (TW = (TC = isPortrait ? {
        'initialPos': 50,
        'bouncePos': -5,
        'finalPos': 0
    } : {
        'initialPos': 100,
        'bouncePos': -10,
        'finalPos': 0
    })["initialPos"]) + "; 0 " + TW + "; 0 " + TC["bouncePos"] + "; 0 0", "keyTimes", "0; 0.7; 0.9; 1", "end", "indefinite")

    divSetAttr(animSVG, "attributeName", "overflow", "dur", "1.5s", "values", "hidden; hidden; visible; visible", "keyTimes", "0; 0.7; " + (isPortrait ? 0.85 : 0.825) + "; 1", "end", "indefinite")
    divSetStyle(pgText, "filter", "blur(4px)")
    TimerID = setTimeout(function () {
        divSetStyle(pgText, "transition", "filter 1.4s 0.5s", "filter", "blur(0px)");
    }, 0)

    divSetAttr(createSVG(document.getElementById("PG-Logo"), "animateTransform"), "attributeName", "transform", "type", "translate", "dur", "1.5s", "values", "0 0; 0 0; 0 -5; 0 0", "keyTimes", "0; 0.88; 0.91; 1", "end", "indefinite")

    Object.values(lb).forEach(function (TV) {
        var TZ, Tx;
        TZ = document.getElementById(TV[0])
        Tx = TV[1]
        divSetAttr(createSVG(TZ, "animateTransform"), "attributeName", "transform", "type", "translate", "dur", "1.6s", "values", "0 0; 0 0; 0 -" + Tx + "; 0 0", "keyTimes", "0; 0.83; 0.88; 1", "end", "indefinite");
    });

    for (var TV = document.getElementById("logo-clip-path"), TZ = document.getElementById("svg-logo-container"), Tx = document.getElementById("PG-Title"), Tq = Object.values(lR), Tz = isPortrait ? "translate(0px, " + TZ["clientHeight"] + "px)" : "translate(" + TZ["clientWidth"] + "px, 0px)", TD = 0; TD < Tx["childElementCount"] - 1; TD++) {
        var TR = createSVG(TV, "path");
        divSetAttr(TR, 'd', Tx["children"][TD]["attributes"]['d']["value"], "clip-rule", "evenodd", "fill-rules", "evenodd"), divSetStyle(TR, "transform", Tz);
    }
    Tq.forEach(function (Tb) {
        for (var TG = document.getElementById(Tb), TL = TG["children"], TM = 0; TM < TG["childElementCount"] - 1; TM++) {
            var TH = createSVG(TV, "path");
            TL[TM]["attributes"]['d'] && divSetAttr(TH, 'd', TL[TM]["attributes"]['d']["value"], "clip-rule", "evenodd", "fill-rules", "evenodd");
        }
    }), TimerID = setTimeout(function () {
        var Tb = document.getElementById("gradient-color"),
            TG = document.getElementById("svg-logo-container"),
            TL = document.getElementById("pg-svg-text");
        divSetStyle(Tb, "transition", "opacity 2s linear"), divSetStyle(TG, "transition", "opacity 2s linear"), divSetStyle(TL, "transition", "opacity 2s linear"), lM(), TimerID = setTimeout(lH, 5500), pgTagIntvalTimerID = setInterval(function () {
            lM(), TimerID = setTimeout(lH, 8000);
        }, 12000);
    }, 3500);
}

function lM() {
    var Tg = document.getElementById("gradient-color"),
        TJ = document.getElementById("svg-logo-container"),
        Tw = document.getElementById("pg-svg-text");
    TJ && (divSetStyle(Tg, "opacity", 1), divSetStyle(TJ, "opacity", 0), divSetStyle(Tw, "opacity", 0)), lG.forEach(function (TO) {
        var TP = document.getElementById("color-" + TO[1]);
        TP && TP.beginElement();
    });
}

function lH() {
    var Tg = document.getElementById("gradient-color"),
        TJ = document.getElementById("svg-logo-container"),
        Tw = document.getElementById("pg-svg-text");
    TJ && (divSetStyle(Tg, "opacity", 0), divSetStyle(TJ, "opacity", 1), divSetStyle(Tw, "opacity", 1)), TimerID = setTimeout(function () {
        lG.forEach(function (TO) {
            var TP = document.getElementById("color-" + TO[1]);
            TP && TP.endElement();
        });
    }, 2000);
}
function destroyPGTag() {
    TimerID && clearTimeout(TimerID)
    pgTagIntvalTimerID && clearInterval(pgTagIntvalTimerID)
}