
/**
 * PG启动页面的PG logo svg 动画
 */

let createLogoAnimation = function (elementNode, height, deltaY, value, index) {
    let svgData = ""
    if (index === 0) {
        svgData = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"112\" height=\"112\">\
                                <path d=\"M90.6 9.8h9.8V0h-9.8Zm0 0\" style=\"stroke:none;fill-rule:evenodd;fill:#ff6e00;fill-opacity:1\"/>\
                                <path d=\"M0 21.1h9.8v-9.8H0Zm0 0\" style=\"stroke:none;fill-rule:evenodd;fill:#6414e6;fill-opacity:1\"/>\
                                <path d=\"M11.3 111.6h9.8v-9.8h-9.8Zm0 0\" style=\"stroke:none;fill-rule:evenodd;fill:#19bee6;fill-opacity:1\"/>\
                                <path d=\"M68 89h9.7v-9.8H68Zm0 0\" style=\"stroke:none;fill-rule:evenodd;fill:#e619dc;fill-opacity:1\"/>\
                                <path d=\"M79.2 9.8H89V0h-9.8ZM68 9.8h9.8V0H68Zm-11.3 0h9.8V0h-9.8Zm-11.3 0H55V0h-9.8ZM34 9.8h9.8V0H34Zm-11.4 0h9.8V0h-9.8Zm-11.3 0h9.8V0h-9.8Zm79.3 11.3h9.8v-9.8h-9.8Zm-11.4 0H89v-9.8h-9.8Zm-11.3 0h9.8v-9.8H68Zm-11.3 0h9.8v-9.8h-9.8Zm-11.3 0H55v-9.8h-9.8Zm-11.3 0h9.8v-9.8H34Zm-11.4 0h9.8v-9.8h-9.8Zm-11.3 0h9.8v-9.8h-9.8ZM102 32.4h9.8v-9.8h-9.8Zm-11.3 0h9.8v-9.8h-9.8Zm-11.4 0H89v-9.8h-9.8Zm-67.9 0h9.8v-9.8h-9.8ZM0 32.4h9.8v-9.8H0Zm101.9 11.3h9.8V34h-9.8Zm-11.3 0h9.8V34h-9.8Zm-79.3 0h9.8V34h-9.8ZM0 43.7h9.8V34H0Zm101.9 11.4h9.8v-9.9h-9.8Zm-11.3 0h9.8v-9.9h-9.8Zm-79.3 0h9.8v-9.9h-9.8ZM0 55h9.8v-9.8H0Zm101.9 11.3h9.8v-9.8h-9.8Zm-11.3 0h9.8v-9.8h-9.8Zm-11.4 0H89v-9.8h-9.8Zm-67.9 0h9.8v-9.8h-9.8ZM0 66.4h9.8v-9.8H0Zm90.6 11.3h9.8v-9.8h-9.8Zm-11.4 0H89v-9.8h-9.8Zm-11.3 0h9.8v-9.8H68Zm-11.3 0h9.8v-9.8h-9.8Zm-11.3 0H55v-9.8h-9.8Zm-11.3 0h9.8v-9.8H34Zm-11.4 0h9.8v-9.8h-9.8Zm-11.3 0h9.8v-9.8h-9.8ZM0 77.7h9.8v-9.8H0ZM56.6 89h9.8v-9.8h-9.8Zm-11.3 0H55v-9.8h-9.8ZM34 89h9.8v-9.8H34Zm-11.4 0h9.8v-9.8h-9.8Zm-11.3 0h9.8v-9.8h-9.8ZM0 89h9.8v-9.8H0Zm11.3 11.3h9.8v-9.8h-9.8Zm-11.3 0h9.8v-9.8H0Zm0 11.3h9.8v-9.8H0Zm0 0\" style=\"stroke:none;fill-rule:evenodd;fill:#fff;fill-opacity:1\"/>\
                            </svg>"
    }
    else {
        svgData = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"113\" height=\"112\">\
                                <path d=\"M.3 32.4h9.8v-9.8H.3Zm0 0\" style=\"stroke:none;fill-rule:evenodd;fill:#e61973;fill-opacity:1\"/>\
                                <path d=\"M22.8 9.8h9.7V0h-9.7Zm0 0\" style=\"stroke:none;fill-rule:evenodd;fill:#ffb919;fill-opacity:1\"/>\
                                <path d=\"M11.6 100.3h9.7v-9.8h-9.7Zm0 0\" style=\"stroke:none;fill-rule:evenodd;fill:#1987e6;fill-opacity:1\"/>\
                                <path d=\"M79 111.6h9.7v-9.8h-9.8Zm0 0\" style=\"stroke:none;fill-rule:evenodd;fill:#ff4b00;fill-opacity:1\"/>\
                                <path d=\"M101.4 55h9.7v-9.7h-9.7Zm0 0\" style=\"stroke:none;fill-rule:evenodd;fill:#14e691;fill-opacity:1\"/>\
                                <path d=\"M101.4 89h9.7v-9.8h-9.7Zm0 0\" style=\"stroke:none;fill-rule:evenodd;fill:#ff1928;fill-opacity:1\"/>\
                                <path d=\"M67.7 9.8h9.7V0h-9.7Zm-11.2 0h9.7V0h-9.7Zm-11.3 0H55V0h-9.8ZM34 9.8h9.8V0H34Zm33.7 11.3h9.7v-9.8h-9.7Zm-11.2 0h9.7v-9.8h-9.7Zm-11.3 0H55v-9.8h-9.8Zm-11.2 0h9.8v-9.8H34Zm56.2 0h9.7v-9.8h-9.7Zm-11.3 0h9.8v-9.8h-9.8Zm-56.1 0h9.7v-9.8h-9.7Zm-11.2 0h9.7v-9.8h-9.7Zm78.6 11.3h9.7v-9.8h-9.7Zm-11.3 0h9.8v-9.8h-9.8Zm-56.1 0h9.7v-9.8h-9.7Zm-11.2 0h9.7v-9.8h-9.7Zm0 11.3h9.7V34h-9.7Zm-11.3 0h9.8V34H.3Zm11.3 11.4h9.7v-9.9h-9.7Zm78.6 0h9.7v-9.9h-9.7Zm-11.3 0h9.8v-9.9h-9.8Zm-11.2 0h9.7v-9.9h-9.7Zm-11.2 0h9.7v-9.9h-9.7ZM.3 55h9.8v-9.9H.3ZM79 66.4h9.8v-9.8h-9.8Zm-11.2 0h9.7v-9.8h-9.7Zm-11.2 0h9.7v-9.8h-9.7Zm-45 0h9.8v-9.8h-9.7Zm89.9 0h9.7v-9.8h-9.7Zm-11.2 0h9.7v-9.8h-9.7Zm-89.9 0h9.8v-9.8H.3Zm101 11.3h9.8v-9.8h-9.7Zm-89.7 0h9.7v-9.8h-9.7Zm78.6 0h9.7v-9.8h-9.7Zm-89.9 0h9.8v-9.8H.3ZM90.2 89h9.7v-9.8h-9.7ZM.3 89h9.8v-9.8H.3ZM79 89h9.8v-9.8h-9.8Zm-56.1 0h9.7v-9.8h-9.7Zm-11.2 0h9.7v-9.8h-9.7Zm78.6 11.3h9.7v-9.8h-9.7Zm-11.3 0h9.8v-9.8h-9.8Zm-11.2 0h9.7v-9.8h-9.7Zm-11.2 0h9.7v-9.8h-9.7Zm-11.3 0H55v-9.8h-9.8Zm-11.2 0h9.8v-9.8H34Zm-11.2 0h9.7v-9.8h-9.7Zm45 11.3h9.6v-9.8h-9.7Zm-11.3 0h9.7v-9.8h-9.7Zm-11.3 0H55v-9.8h-9.8Zm-11.2 0h9.8v-9.8H34Zm-11.2 0h9.7v-9.8h-9.7Zm0 0\" style=\"stroke:none;fill-rule:evenodd;fill:#fff;fill-opacity:1\"/>\
                            </svg>"
    }
    let svgAnimNode = createSVGNode(elementNode, 'g');
    setElementAttributes(svgAnimNode, 'id', "digit-" + value)
    setTransform(svgAnimNode, "filter", "url(#motionFilter-" + value + ')');
    for (let i = 0; i < 11; i++) {
        let gNode = createSVGNode(svgAnimNode, 'g');
        setTransform(gNode, "transform", "translate(0px, " + -i * (height + 2 * deltaY) + "px)")
        gNode.innerHTML = svgData;
    }
    return svgAnimNode;
}

function createSVGNode(parentNode, nodeName) {
    var svgNode = document.createElementNS("http://www.w3.org/2000/svg", nodeName);
    parentNode.appendChild(svgNode)
    return svgNode;
}

function setTransform(...args) {
    let element = args[0]
    for (let idx = 1; idx < args.length; idx += 2) {
        element.style[args[idx]] = args[idx + 1];
    }
    return element;
}

function setElementAttributes(...args) {
    let element = args[0]
    for (let idx = 1; idx < args.length; idx += 2) {
        element.setAttribute(args[idx], args[idx + 1]);
    }
    return element;
}

var getScaleRatio = function (width, height) {
    return width / height > 0.5625 ? 1920 / height : 1080 / width;
}

var createBlurEffect = function (node, value) {
    var n1 = createSVGNode(node, "filter");
    setElementAttributes(n1, 'id', "motionFilter-" + value, "width", "300%", 'x', "-100%");
    var n2 = createSVGNode(n1, "feGaussianBlur");
    setElementAttributes(n1, "class", "blurValues", 'in', "SourceGraphic", "stdDeviation", "0 0")
    return n2;
};

function showLogoAnimation(params) {
    var S5, scaleRatio, windowResizeCallback,
        S8 = params['h'],
        S9 = params['t'],
        SS = params['v'],
        Sc = params['i'],
        Si = params['o'],
        SJ = params['l'],
        logoText = params['m'],
        SG = document.querySelector(SJ),
        SO = (S5 = SG,
            scaleRatio = getScaleRatio(0x5a0, 0x400),
            windowResizeCallback = function () {
                var Sa = getScaleRatio(window.innerWidth, window.innerHeight);
                setTransform(S5, "transform", "scale(" + (scaleRatio / Sa).toFixed(0x4) + ')');
            }
            ,
            window.addEventListener("resize", windowResizeCallback),
            windowResizeCallback(),
            function () {
                window.removeEventListener("resize", windowResizeCallback);
            }
        ),
        SZ = 0x70,
        SW = S8,
        SX = SZ + 0x2 * S8,
        nowTS = Date.now(),
        SA = createSVGNode(SG, "svg"),
        SQ = createSVGNode(SA, "svg");

    setElementAttributes(SQ, "mask", "url(#mask-" + nowTS + ')');

    var Sk = createSVGNode(SA, "defs");

    !function (Sa, SI) {
        var ST = createSVGNode(Sa, "linearGradient");
        setElementAttributes(ST, 'id', "gradient-" + SI, 'x1', '0%', 'y1', '0%', 'x2', '0%', 'y2', "100%"),
            function () {
                for (var Se = arguments, So = 0; So < Se.length; So++) {
                    var SC = createSVGNode(ST, "stop")
                        , SH = Se[So];
                    setElementAttributes(SC, "offset", SH[0], "stop-color", "white", "stop-opacity", SH[1]);
                }
            }([0, 0], [0.2, 1], [0.8, 1], [1, 0]);
    }(Sk, nowTS),
        function (Sa, SI) {
            var ST = createSVGNode(Sa, "mask");
            setElementAttributes(ST, 'id', "mask-" + SI),
                setElementAttributes(createSVGNode(ST, "rect"), 'x', 0x0, 'y', 0x0, "width", "100%", "height", "100%", "fill", "url(#gradient-" + SI + ')');
        }(Sk, nowTS),
        function (Sa, SI) {
            var ST, Se, So;
            setTransform((ST = Sa,
                Se = SI,
                So = document.createElement("pre"),
                ST.appendChild(So),
                So["textContent"] = Se,
                So), "font", "20px Roboto, sans-serif", "color", "#ccc", "opacity", '0', "text-align", "center", "animation", "1.2s ease-in-out forwards fade-in");
        }(SG, logoText);

    var SVGData = ['1', '1'].map(function (elementValue, index) {
        var v = index + '-' + nowTS;
        return {
            'Z': createLogoAnimation(SQ, SZ, S8, v, index),
            'u': createBlurEffect(Sk, v),
            'H': +elementValue,
            'p': 0,
            'M': {
                'x': index * (SZ + S9),
                'y': SW
            }
        };
    });

    !function (Sa, SI, ST) {
        setElementAttributes(Sa, "viewBox", "0 0 " + SI + '\x20' + ST),
            setTransform(Sa, "overflow", "hidden", "height", ST);
    }(SA, SVGData.length * (SZ + S9) - S9, SX),
        SVGData.forEach(function (Sa) {
            setElementAttributes(Sa.Z, "transform", "translate(" + Sa.M.x + ',\x20' + Sa.M.y + ')');
        });

    var Sy = [];
    !function Sa() {
        Sy.length = 0
        SVGData.forEach(function (SI, ST) {
            var Se = SI['p'] * SX
                , So = (0x4d + SI['H']) * SX
                , SC = function (cfgParams) {
                    var Sr = cfgParams['g']
                        , Sx = cfgParams["_to"]
                        , Ss = cfgParams['o']
                        , SK = cfgParams['V']
                        , SU = cfgParams['_']
                        , SF = cfgParams['k']
                        , Sh = cfgParams['D']
                        , Sj = Sr
                        , SL = void 0x0
                        , Sd = !0x1;
                    return function (Sb) {
                        if (!Sd) {
                            void 0x0 === SL && (SL = Sb,
                                SU(Sj));
                            var Sg, SR = Math.min(Math.max(Sb - SL - SK, 0x0), Ss) / Ss;
                            SF(Sj = ((Sg = SR) <= 0.3 ? Sg * Sg : 0x1 + 1.25 * Math.pow(Sg - 0x1, 0x3) + 0.25 * Math.pow(Sg - 0x1, 0x2)) * (Sx - Sr) + Sr),
                                0x1 === SR && (Sd = !0x0,
                                    Sh(Sj));
                        }
                    }
                        ;
                }({
                    'g': Se,
                    '_to': So,
                    'o': Si,
                    'V': (SVGData.length - 0x1 - ST) * Sc + SS,
                    '_': function () { },
                    'k': function (SH) {
                        SI.M.y = SW + SH % (0xb * SX),
                            setElementAttributes(SI.Z, "transform", "translate(" + SI.M.x + ',\x20' + SI.M.y + ')');
                        var Sr = (Se + So) / 0x2
                            , Sx = (+Math.abs(Math.abs(Math.abs(SH - Sr) - Sr) - Se) / 0x64)["toFixed"](0x1);
                        setElementAttributes(SI.u, "stdDeviation", '0\x20' + Sx);
                    },
                    'D': function () {
                        0x0 === ST && (document.querySelector(SJ) ? Sa() : (SN(),
                            SO()));
                    }
                });
            Sy.push(SC);
        });
    }();

    var Sm, Sz, SN = (Sm = function (SI) {
        Sy.forEach(function (ST) {
            return ST(SI);
        });
    },
        function SI(ST) {
            Sz = requestAnimationFrame(SI)
            Sm(ST)
        }(0),
        function () {
            cancelAnimationFrame(Sz);
        }
    );
}

var loadErrTips = {};
loadErrTips['en'] = "Unable to load game. Press [OK] to refresh or [Cancel] to ignore.";
loadErrTips['zh'] = "\u672A\u80FD\u52A0\u8F7D\u6E38\u620F\uFF0C\u70B9\u51FB\"\u786E\u5B9A\"\u8FDB\u884C\u91CD\u8BD5\u6216\u8005\"\u53D6\u6D88\"\u3002";
loadErrTips['th'] = "\u0E44\u0E21\u0E48\u0E2A\u0E32\u0E21\u0E32\u0E23\u0E16\u0E14\u0E32\u0E27\u0E19\u0E4C\u0E42\u0E2B\u0E25\u0E14\u0E40\u0E01\u0E21\u0E44\u0E14\u0E49 \u0E43\u0E2B\u0E49\u0E04\u0E25\u0E34\u0E01\u0E17\u0E35\u0E48 \u201D\u0E22\u0E37\u0E19\u0E22\u0E31\u0E19\u201D \u0E40\u0E1E\u0E37\u0E48\u0E2D\u0E25\u0E2D\u0E07\u0E43\u0E2B\u0E21\u0E48 \u0E2B\u0E23\u0E37\u0E2D\u0E17\u0E35\u0E48 \u201C\u0E22\u0E01\u0E40\u0E25\u0E34\u0E01\u201D \u0E40\u0E1E\u0E37\u0E48\u0E2D\u0E2D\u0E2D\u0E01";
loadErrTips['id'] = "Permainan tidak bisa diunduh. Klik \u2018Konfirmasi\u2019 untuk coba lagi atau \u2018Batalkan\u2019 untuk keluar.";
loadErrTips['vi'] = "Kh\xF4ng th\u1EC3 t\u1EA3i v\u1EC1 tr\xF2 ch\u01A1i. Nh\u1EA5p v\xE0o \u2018X\xE1c nh\u1EADn\u2019 \u0111\u1EC3 th\u1EED l\u1EA1i ho\u1EB7c \u2018H\u1EE7y\u2019 \u0111\u1EC3 tho\xE1t.";
loadErrTips['ja'] = "\u30B2\u30FC\u30E0\u3092\u30C0\u30A6\u30F3\u30ED\u30FC\u30C9\u3067\u304D\u307E\u305B\u3093\u3002[\u78BA\u8A8D] \u3092\u30AF\u30EA\u30C3\u30AF\u3057\u3066\u3082\u3046\u4E00\u5EA6\u8A66\u3059\u304B\u3001[\u30AD\u30E3\u30F3\u30BB\u30EB] \u3092\u30AF\u30EA\u30C3\u30AF\u3057\u3066\u7D42\u4E86\u3057\u3066\u304F\u3060\u3055\u3044\u3002";
loadErrTips['ko'] = "\uAC8C\uC784\uC744 \uB2E4\uC6B4\uB85C\uB4DC\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4. \u2018\uD655\uC778\u2019\uC744 \uD074\uB9AD\uD558\uC5EC \uB2E4\uC2DC \uC2DC\uB3C4\uD558\uAC70\uB098 \u2018\uCDE8\uC18C\u2019\uB97C \uD074\uB9AD\uD558\uC5EC \uC885\uB8CC\uD558\uC138\uC694.";
loadErrTips['sv'] = "Spelet kan inte laddas ner. Klicka p\xE5 Bekr\xE4fta f\xF6r att f\xF6rs\xF6ka igen, eller p\xE5 Avbryt f\xF6r att l\xE4mna.";

var needUpdateTips = {};
needUpdateTips['en'] = "Sorry, this game cannot be loaded as the existing resources are out of date. Please try again later.";
needUpdateTips['zh'] = "\u5BF9\u4E0D\u8D77\uFF0C\u7531\u4E8E\u5F53\u524D\u8D44\u6E90\u4E0D\u662F\u6700\u65B0\u7248\u672C\uFF0C\u56E0\u6B64\u6E38\u620F\u65E0\u6CD5\u52A0\u8F7D\uFF0C\u8BF7\u7A0D\u540E\u518D\u8BD5\u3002";
needUpdateTips['th'] = "\u0E02\u0E2D\u0E2D\u0E20\u0E31\u0E22 \u0E44\u0E21\u0E48\u0E2A\u0E32\u0E21\u0E32\u0E23\u0E16\u0E42\u0E2B\u0E25\u0E14\u0E40\u0E01\u0E21\u0E19\u0E35\u0E49\u0E44\u0E14\u0E49\u0E40\u0E19\u0E37\u0E48\u0E2D\u0E07\u0E08\u0E32\u0E01\u0E02\u0E49\u0E2D\u0E21\u0E39\u0E25\u0E1B\u0E31\u0E08\u0E08\u0E38\u0E1A\u0E31\u0E19\u0E44\u0E21\u0E48\u0E43\u0E0A\u0E48\u0E02\u0E49\u0E2D\u0E21\u0E39\u0E25\u0E25\u0E48\u0E32\u0E2A\u0E38\u0E14 \u0E01\u0E23\u0E38\u0E13\u0E32\u0E25\u0E2D\u0E07\u0E43\u0E2B\u0E21\u0E48\u0E2D\u0E35\u0E01\u0E04\u0E23\u0E31\u0E49\u0E07\u0E43\u0E19\u0E20\u0E32\u0E22\u0E2B\u0E25\u0E31\u0E07";
needUpdateTips['id'] = "Maaf, permainan ini tidak bisa dimuat karena sumber daya yang ada sudah kedaluwarsa. Silakan coba lagi nanti.";
needUpdateTips['vi'] = "R\u1EA5t ti\u1EBFc, kh\xF4ng th\u1EC3 t\u1EA3i tr\xF2 ch\u01A1i n\xE0y v\xEC c\xE1c t\xE0i nguy\xEAn hi\u1EC7n t\u1EA1i \u0111\xE3 qu\xE1 c\u0169. Vui l\xF2ng th\u1EED l\u1EA1i sau.";
needUpdateTips['ja'] = "\u7533\u3057\u8A33\u3042\u308A\u307E\u305B\u3093\u3002\u73FE\u5728\u306E\u30EA\u30BD\u30FC\u30B9\u304C\u53E4\u3044\u305F\u3081\u3001\u3053\u306E\u30B2\u30FC\u30E0\u3092\u8AAD\u307F\u8FBC\u3080\u3053\u3068\u306F\u3067\u304D\u307E\u305B\u3093\u3002\u5F8C\u3067\u3082\u3046\u4E00\u5EA6\u304A\u8A66\u3057\u304F\u3060\u3055\u3044\u3002";
needUpdateTips['ko'] = "\uC8C4\uC1A1\uD569\uB2C8\uB2E4.\uC774 \uAC8C\uC784\uC740 \uAE30\uC874 \uB9AC\uC18C\uC2A4\uAC00 \uAD6C\uC2DD\uC774\uBBC0\uB85C\uB85C\uB4DC \uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4. \uB098\uC911\uC5D0 \uB2E4\uC2DC \uC2DC\uB3C4 \uD574\uC8FC\uC2ED\uC2DC\uC624.";
needUpdateTips['sv'] = "Det h\xE4r spelet kan inte laddas eftersom de nuvarande resurserna \xE4r inaktuella. F\xF6rs\xF6k igen senare.";

var slogon = {};
slogon['en'] = "DIFFERENCE MAKES THE DIFFERENCE";
slogon['zh'] = "\u4E0D  \u51E1   \u6210   \u5C31   \u975E   \u51E1";
slogon['de'] = "DER UNTERSCHIED MACHT DEN UNTERSCHIED";
slogon['es'] = "LA DIFERENCIA QUE MARCA LA DIFERENCIA";
slogon['th'] = "\u0E04\u0E27\u0E32\u0E21\u0E41\u0E15\u0E01\u0E15\u0E48\u0E32\u0E07 \u0E17\u0E35\u0E48\u0E40\u0E1B\u0E47\u0E19\u0E15\u0E31\u0E27\u0E15\u0E31\u0E14\u0E2A\u0E34\u0E19";
slogon['id'] = "PERBEDAAN YANG MEMBUAT PERBEDAAN";
slogon['vi'] = "S\u1EF0 KH\xC1C BI\u1EC6T T\u1EA0O N\xCAN S\u1EF0 KH\xC1C BI\u1EC6T";
slogon['ja'] = "\u9055 \u3044 \u304C   \u9055 \u3044 \u3092 \u751F \u307F \u3060 \u3059";
slogon['ko'] = "\uCC28 \uC774 \uB97C   \uB9CC \uB4DC \uB294   \uCC28 \uC774";
slogon['ru'] = "\u0418\u041D\u0414\u0418\u0412\u0418\u0414\u0423\u0410\u041B\u042C\u041D\u041E\u0421\u0422\u042C \u0418\u041C\u0415\u0415\u0422 \u0417\u041D\u0410\u0427\u0415\u041D\u0418\u0415";
slogon['sv'] = "SKILLNADEN SOM G\xD6R SKILLNAD";

var tipsMap = {};
tipsMap['0'] = loadErrTips;
tipsMap['1'] = needUpdateTips;
tipsMap['2'] = slogon;

function getSlogonText(tipsType) {
    var tips = tipsMap[tipsType];
    return tips ? tips[curLang] || tips['en'] : ''.concat(tipsType);
}

var svgConfig = {};
svgConfig['h'] = 20;
svgConfig['t'] = 25;
svgConfig['v'] = 400;
svgConfig['i'] = 200;
svgConfig['o'] = 1200;
svgConfig['l'] = ".svg-loading";
svgConfig['m'] = getSlogonText(2)

var loaderNode = document.getElementById("initial-loader");
if (loaderNode) {
    loaderNode.style.backgroundColor = "black"
}