window.boot = function () {
    var settings = window._CCSettings;
    window._CCSettings = undefined;
    var onProgress = null;

    var RESOURCES = cc.AssetManager.BuiltinBundleName.RESOURCES;
    var INTERNAL = cc.AssetManager.BuiltinBundleName.INTERNAL;
    var MAIN = cc.AssetManager.BuiltinBundleName.MAIN;
    function setLoadingDisplay() {
        let recordTS = Date.now()
        // Loading splash scene
        cc.director.once(cc.Director.EVENT_AFTER_SCENE_LAUNCH, function () {
            let timeCost = Date.now() - recordTS
            let delay = timeCost > 400 ? timeCost : 400
            showFullScreenBackground()
            createSplashDiv()
            setTimeout(() => {
                showLoadingPage();
            }, delay);
        });
    }
    document.addEventListener("fullscreenchange", function () {
        if (document.fullscreenElement) {
            console.log("进入全屏模式");
            if (settings.orientation === 'portrait') {
                var lockFunction = screen.orientation.lock;
                if (lockFunction) {
                    lockFunction.call(screen.orientation, 'portrait-primary')
                        .then(null, function (error) {
                            // 锁定失败
                            console.log("不能锁定屏幕：" + error);
                        });
                } else {
                    console.log("不能锁定屏幕");
                }
            }
        } else {
            console.log("退出全屏模式");
        }
    }, false);

    cc.view._resizeEvent = function _resizeEvent(forceOrEvent) {
        var view;
        view = this.setDesignResolutionSize ? this : cc.view;
        var sys = cc.sys;
        if (sys.browserType === sys.BROWSER_TYPE_UC && sys.os === sys.OS_IOS) {
            setTimeout((function () {
                view._resizeEvent(forceOrEvent);
            }), 0);
            return;
        }
        var prevFrameW = view._frameSize.width, prevFrameH = view._frameSize.height, prevRotated = view._isRotated;
        if (cc.sys.isMobile) {
            var containerStyle = cc.game.container.style, margin = containerStyle.margin;
            containerStyle.margin = "0";
            containerStyle.display = "none";
            view._initFrameSize();
            containerStyle.margin = margin;
            containerStyle.display = "block";
        } else view._initFrameSize();
        // if (true !== forceOrEvent && view._isRotated === prevRotated && view._frameSize.width === prevFrameW && view._frameSize.height === prevFrameH) return;
        var width = view._originalDesignResolutionSize.width;
        var height = view._originalDesignResolutionSize.height;
        view._resizing = true;
        view.setDesignResolutionSize(width, height, view._resolutionPolicy);
        view._resizing = false;
        view.emit("canvas-resize");
        view._resizeCallback && view._resizeCallback.call();
    }
    // 获取你想要修改的类
    var EqualToFrame = cc.ContainerStrategy["EQUAL_TO_FRAME"];

    EqualToFrame.apply = function apply(view) {
        // 你的新方法实现
        var frameH = view._frameSize.height;
        var containerStyle = cc.game.container.style;
        this._setupContainer(view, view._frameSize.width, view._frameSize.height);

        if (view._isRotated) {
            if (window["orientation"] === -90) {
                containerStyle.margin = "0 0 0 " + frameH + "px";
            } else {
                containerStyle.margin = view._frameSize.width + "px 0 0 0 ";
            }
        } else {
            containerStyle.margin = "0px";
        }

        containerStyle.padding = "0px";
    }
    var ProportionalToFrame = cc.ContainerStrategy["PROPORTION_TO_FRAME"];

    ProportionalToFrame.apply = function apply(view, designedResolution) {
        // 你的自定义方法实现
        var frameW = view._frameSize.width, frameH = view._frameSize.height, containerStyle = cc.game.container.style,
            designW = designedResolution.width, designH = designedResolution.height,
            scaleX = frameW / designW, scaleY = frameH / designH, containerW, containerH;

        scaleX < scaleY ? (containerW = frameW, containerH = designH * scaleX) : (containerW = designW * scaleY,
            containerH = frameH);

        var offx = Math.round((frameW - containerW) / 2);
        var offy = Math.round((frameH - containerH) / 2);
        containerW = frameW - 2 * offx;
        containerH = frameH - 2 * offy;

        this._setupContainer(view, containerW, containerH);

        if (view._isRotated) {
            if (window["orientation"] === -90) {
                containerStyle.margin = "0 0 0 " + frameH + "px";
            } else {
                containerStyle.margin = view._frameSize.width + "px 0 0 0 ";
            }
        } else {
            containerStyle.margin = "0px";
        }

        containerStyle.paddingLeft = offx + "px";
        containerStyle.paddingRight = offx + "px";
        containerStyle.paddingTop = offy + "px";
        containerStyle.paddingBottom = offy + "px";
    }
    cc.view._initFrameSize = function _initFrameSize() {
        var locFrameSize = this._frameSize;
        var w = window.innerWidth;
        var h = window.innerHeight;
        var isLandscape = w >= h;
        if ((false, !cc.sys.isMobile) || isLandscape && this._orientation & cc.macro.ORIENTATION_LANDSCAPE || !isLandscape && this._orientation & cc.macro.ORIENTATION_PORTRAIT) {
            locFrameSize.width = w;
            locFrameSize.height = h;
            cc.game.container.style["-webkit-transform"] = "rotate(0deg)";
            cc.game.container.style.transform = "rotate(0deg)";
            this._isRotated = false;
        } else {
            locFrameSize.width = h;
            locFrameSize.height = w;
            var rotate = "rotate(-90deg)"
            if (window["orientation"] === -90) {
                rotate = "rotate(90deg)"
            }
            cc.game.container.style["-webkit-transform"] = rotate;
            cc.game.container.style.transform = rotate;
            cc.game.container.style["-webkit-transform-origin"] = "0px 0px 0px";
            cc.game.container.style.transformOrigin = "0px 0px 0px";
            this._isRotated = true;
        }
        this._orientationChanging && setTimeout((function () {
            cc.view._orientationChanging = false;
        }), 1e3);
    }
    cc.view.convertToLocationInView = function convertToLocationInView(tx, ty, relatedPos, out) {
        var result = out || cc.v2();
        var posLeft = relatedPos.adjustedLeft ? relatedPos.adjustedLeft : relatedPos.left;
        var posTop = relatedPos.adjustedTop ? relatedPos.adjustedTop : relatedPos.top;
        var x = this._devicePixelRatio * (tx - posLeft);
        var y = this._devicePixelRatio * (posTop + relatedPos.height - ty);
        if (this._isRotated) {
            result.x = cc.game.canvas.width - y;
            result.y = x;
            if (cc.game.container.style["-webkit-transform"] == "rotate(-90deg)") {
                result.x = y;
                result.y = cc.game.canvas.height - x;
            }
        } else {
            result.x = x;
            result.y = y;
        }
        return result;
    }
    var onStart = function () {

        cc.view.enableRetina(true);
        cc.view.resizeWithBrowserSize(true);

        if (cc.sys.isBrowser) {
            setLoadingDisplay();
        }

        if (cc.sys.isMobile) {
            if (settings.orientation === 'landscape') {
                cc.view.setOrientation(cc.macro.ORIENTATION_LANDSCAPE);
            }
            else if (settings.orientation === 'portrait') {
                cc.view.setOrientation(cc.macro.ORIENTATION_PORTRAIT);
            }
            cc.view.enableAutoFullScreen([
                cc.sys.BROWSER_TYPE_BAIDU,
                cc.sys.BROWSER_TYPE_BAIDU_APP,
                cc.sys.BROWSER_TYPE_WECHAT,
                cc.sys.BROWSER_TYPE_MOBILE_QQ,
                cc.sys.BROWSER_TYPE_MIUI,
                cc.sys.BROWSER_TYPE_HUAWEI,
                cc.sys.BROWSER_TYPE_UC,
            ].indexOf(cc.sys.browserType) < 0);
        }

        // Limit downloading max concurrent task to 2,
        // more tasks simultaneously may cause performance draw back on some android system / browsers.
        // You can adjust the number based on your own test result, you have to set it before any loading process to take effect.
        if (cc.sys.isBrowser && cc.sys.os === cc.sys.OS_ANDROID) {
            cc.assetManager.downloader.maxConcurrency = 2;
            cc.assetManager.downloader.maxRequestsPerFrame = 2;
        }

        var launchScene = settings.launchScene;
        var bundle = cc.assetManager.bundles.find(function (b) {
            return b.getSceneInfo(launchScene);
        });

        bundle.loadScene(launchScene, null, onProgress,
            function (err, scene) {
                if (!err) {
                    cc.director.runSceneImmediate(scene);
                    if (cc.sys.isBrowser) {
                        // show canvas
                        var canvas = document.getElementById('GameCanvas');
                        canvas.style.visibility = '';
                        var div = document.getElementById('GameDiv');
                        if (div) {
                            div.style.backgroundImage = '';
                        }
                        console.log('Success to load scene: ' + launchScene);
                    }
                }
            }
        );

    };

    var option = {
        id: 'GameCanvas',
        debugMode: settings.debug ? cc.debug.DebugMode.INFO : cc.debug.DebugMode.ERROR,
        showFPS: settings.debug,
        frameRate: 60,
        groupList: settings.groupList,
        collisionMatrix: settings.collisionMatrix,
    };

    cc.assetManager.init({
        bundleVers: settings.bundleVers,
        remoteBundles: settings.remoteBundles,
        server: settings.server
    });

    var bundleRoot = [INTERNAL];
    settings.hasResourcesBundle && bundleRoot.push(RESOURCES);

    var count = 0;
    function cb(err) {
        if (err) return console.error(err.message, err.stack);
        count++;
        if (count === bundleRoot.length + 1) {
            cc.assetManager.loadBundle(MAIN, function (err) {
                if (!err) cc.game.run(option, onStart);
            });
        }
    }

    cc.assetManager.loadScript(settings.jsList.map(function (x) { return 'src/' + x; }), cb);

    for (var i = 0; i < bundleRoot.length; i++) {
        cc.assetManager.loadBundle(bundleRoot[i], cb);
    }
};

if (window.jsb) {
    var isRuntime = (typeof loadRuntime === 'function');
    if (isRuntime) {
        require('src/settings.57128.js');
        require('src/cocos2d-runtime.js');
        if (CC_PHYSICS_BUILTIN || CC_PHYSICS_CANNON) {
            require('src/physics.js');
        }
        require('jsb-adapter/engine/index.js');
    }
    else {
        require('src/settings.57128.js');
        require('src/cocos2d-jsb.js');
        if (CC_PHYSICS_BUILTIN || CC_PHYSICS_CANNON) {
            require('src/physics.js');
        }
        require('jsb-adapter/jsb-engine.js');
    }

    cc.macro.CLEANUP_IMAGE_CACHE = true;
    window.boot();
}